local function allGood(self)
	for i, byte in ipairs(self.byte) do
		for j, lever in ipairs(byte) do
			if lever.State ~= self.goodPos[i][j] then
				return false
			end
		end
	end
	return true
end

local function randomGoodie()
	local lottery = math.random(100)
	if lottery <= 95 then
		return "GAME_TREASURE_NECKLACE"
	elseif lottery == 96 then
		return "GAME_POWERUPS_EXTRALIFE"
	elseif lottery == 97 then
		return "GAME_AMMO_SHOT"
	elseif lottery == 98 then
		return "GAME_AMMO_SHOTBAG"
	elseif lottery == 99 then
		return "GAME_DYNAMITE"
	else
		return "GAME_MAGIC_GLOW"
	end
end

local function randomDir()
	return math.random(2) == 2 and -1 or 1
end

function main(self)
	local claw = GetClaw()
	if self.State == 0 then
		self.byte1 = { }
		self.byte2 = { }
		self.byte3 = { }
		self.Flags.AlwaysActive, self.DrawFlags.NoDraw = true, true
		self.byte = {
			{
				GetObject(3295),
				GetObject(3294),
				GetObject(3293),
				GetObject(3291),
				GetObject(3292),
				GetObject(3288),
				GetObject(3289),
				GetObject(3290)
			},
			{
				GetObject(3287),
				GetObject(3286),
				GetObject(3285),
				GetObject(3280),
				GetObject(3281),
				GetObject(3282),
				GetObject(3283),
				GetObject(3284)
			},
			{
				GetObject(3279),
				GetObject(3245),
				GetObject(3261),
				GetObject(3246),
				GetObject(3277),
				GetObject(3247),
				GetObject(3278),
				GetObject(3248)
			}
		}

		self.goodPos = { 		-- 0xB8, 0x72, 0x3A
			{5, 7, 5, 5, 5, 7, 7, 7},
			{7, 5, 5, 5, 7, 7, 5, 7},
			{7, 7, 5, 5, 5, 7, 5, 7}
		}

		self.XMin, self.XMax, self.YMin, self.YMax = 2140, 4300, 5600, 5850

		self.State = 1
	end

	if self.State == 1 and claw:InMinMax(self) then
		if allGood(self) then
			TextOut('"For nothing is hidden that will not be revealed, nor anything hidden that will not be known and come to light." ~ Luke 8:17')
			Earthquake(3000)
			PlaySound("CUSTOM_EARTHQUAKE")
			self.timeDelay = 0
			self.Counter = 0
			self.State = 2
		end
	end

	if self.State == 2 then
		if GetTime() > self.timeDelay then
			CreateObject{
				X = self.XMin + math.random(self.XMax-self.XMin),
				Y = self.YMin + math.random(self.YMax-self.YMin),
				Z = 3000,
				logic = "BouncingGoodie",
				image = randomGoodie(),
				SpeedX = math.random(160,300)*randomDir(),
				SpeedY = -math.random(100,300)
			}
			self.Counter = self.Counter + 1
			self.timeDelay = GetTime() + 30
		end
		if self.Counter == 100 then
			self:Destroy()
		end
	end
end